/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server.tag;

import dev.latvian.mods.kubejs.event.EventExceptionHandler;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.server.tag.EmptyTagTargetException;
import dev.latvian.mods.kubejs.server.tag.TagEventFilter;
import dev.latvian.mods.kubejs.server.tag.TagWrapper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3503;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;

public class TagEventJS
extends EventJS {
    public static final EventExceptionHandler TAG_EVENT_HANDLER = (event, container, ex) -> {
        if (ex instanceof IllegalStateException) {
            StackTraceElement[] stacktrace = ex.getStackTrace();
            if (stacktrace.length > 0 && stacktrace[0].toString().contains("dev.latvian.mods.rhino.ScriptRuntime.doTopCall")) {
                Throwable error = ex.getCause() == null ? ex : ex.getCause();
                ConsoleJS.SERVER.error("IllegalStateException was thrown during tag event in script %s:%d, this is most likely due to a concurrency bug in Rhino! While we are working on a fix for this issue, you may manually work around it by reloading the server again (e.g. by using /reload command).".formatted(container.source, container.line), error);
                return null;
            }
        } else if (ex instanceof EmptyTagTargetException) {
            ConsoleJS.SERVER.error(ex.getMessage() + " (at %s:%d)".formatted(container.source, container.line));
            return null;
        }
        return ex;
    };
    public static final String SOURCE = "KubeJS Custom Tags";
    public final RegistryInfo registry;
    public final class_2378<?> vanillaRegistry;
    public final Map<class_2960, TagWrapper> tags;
    public int totalAdded;
    public int totalRemoved;
    private Set<class_2960> elementIds;

    public TagEventJS(RegistryInfo ri, class_2378<?> vr) {
        this.registry = ri;
        this.vanillaRegistry = vr;
        this.tags = new ConcurrentHashMap<class_2960, TagWrapper>();
        this.totalAdded = 0;
        this.totalRemoved = 0;
    }

    public class_2960 getType() {
        return this.registry.key.method_29177();
    }

    public TagWrapper get(class_2960 id) {
        return this.tags.computeIfAbsent(id, this::createTagWrapper);
    }

    protected TagWrapper createTagWrapper(class_2960 id) {
        return new TagWrapper(this, id, new ArrayList<class_3503.class_5145>());
    }

    public TagWrapper add(class_2960 tag, Object ... filters) {
        return this.get(tag).add(filters);
    }

    public TagWrapper remove(class_2960 tag, Object ... filters) {
        return this.get(tag).remove(filters);
    }

    public TagWrapper removeAll(class_2960 tag) {
        return this.get(tag).removeAll();
    }

    public void removeAllTagsFrom(Object ... ids) {
        TagEventFilter filter = TagEventFilter.unwrap(this, ids);
        for (TagWrapper tagWrapper : this.tags.values()) {
            tagWrapper.entries.removeIf(proxy -> filter.testTagOrElementLocation(proxy.comp_324().method_43936()));
        }
    }

    public Set<class_2960> getElementIds() {
        if (this.elementIds == null) {
            this.elementIds = (Set)UtilsJS.cast(this.vanillaRegistry.method_40270().map(class_6880.class_6883::method_40237).map(class_5321::method_29177).collect(Collectors.toSet()));
        }
        return this.elementIds;
    }

    void gatherIdsFor(TagWrapper excluded, Collection<class_2960> collection, class_3503.class_5145 entry) {
        class_5699.class_7476 id = entry.comp_324().method_43936();
        if (id.comp_814()) {
            TagWrapper w = this.tags.get(id.comp_813());
            if (w != null && w != excluded) {
                for (class_3503.class_5145 proxy : w.entries) {
                    this.gatherIdsFor(excluded, collection, proxy);
                }
            }
        } else {
            class_2960 entryId = id.comp_813();
            if (this.getElementIds().contains(entryId)) {
                collection.add(entryId);
            }
        }
    }
}

